package vastxmlstructs

import "encoding/xml"

type VastTypes struct {
	VAST2   *VAST2
	WVAST2  *WVAST2
	VAST3   *VAST3
	WVAST3  *WVAST3
	VAST4   *VAST4
	WVAST4  *WVAST4
	VAST41  *VAST41
	WVAST41 *WVAST41
	OVAST2   *OVAST2
}

type OVAST2 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       Ad
}

type VAST2 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       Ad
}

type WVAST2 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       WAd      `xml:"Ad"`
}

type VAST3 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       Ad3      `xml:"Ad"`
}

type WVAST3 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       WAd3     `xml:"Ad"`
}

type VAST4 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       Ad4      `xml:"Ad"`
}

type WVAST4 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       WAd4     `xml:"Ad"`
}

type VAST41 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       Ad41     `xml:"Ad"`
}

type WVAST41 struct {
	XMLName  xml.Name `xml:"VAST"`
	Xmlnsxsi string   `xml:"http://www.w3.org/2001/XMLSchema-instance/xsi xsi,attr"`
	Version  string   `xml:"version,attr"`
	Ad       WAd41    `xml:"Ad"`
}

type WAd struct {
	Id      string `xml:"id,attr"`
	Wrapper Wrapper
}

type WAd3 struct {
	Id      string `xml:"id,attr"`
	Wrapper Wrapper
}

type WAd4 struct {
	Id            string `xml:"id,attr"`
	ConditionalAd string `xml:"conditionalAd,attr"`
	Wrapper       Wrapper4
}

type WAd41 struct {
	Id            string `xml:"id,attr"`
	ConditionalAd string `xml:"conditionalAd,attr"`
	Wrapper       Wrapper41
}

type Ad struct {
	Id     string `xml:"id,attr"`
	InLine InLine
}

type Ad3 struct {
	Id     string  `xml:"id,attr"`
	InLine InLine3 `xml:"InLine"`
}

type Ad4 struct {
	Id            string  `xml:"id,attr"`
	ConditionalAd string  `xml:"conditionalAd,attr"`
	InLine        InLine4 `xml:"InLine"`
}

type Ad41 struct {
	Id     string   `xml:"id,attr"`
	AdType string   `xml:"adType,attr"`
	InLine InLine41 `xml:"InLine"`
}

type Wrapper struct {
	AdSystem     string
	AdTitle      string
	Impression   []Impression
	VASTAdTagURI string
	Creatives    []Creative `xml:"Creatives>Creative"`
}

type Wrapper4 struct {
	FallbackOnNoAd           string `xml:"fallbackOnNoAd,attr"`
	AllowMultipleAds         string `xml:"allowMultipleAds,attr"`
	FollowAdditionalWrappers string `xml:"followAdditionalWrappers,attr"`
	AdSystem                 string
	Error                    string
	ViewableImpression       *ViewableImpression `xml:",omitempty"`
	Pricing                  Pricing4
	Impression               []Impression
	VASTAdTagURI             string
	Creatives                []Creative4 `xml:"Creatives>Creative"`
}

type Wrapper41 struct {
	FallbackOnNoAd           string `xml:"fallbackOnNoAd,attr"`
	AllowMultipleAds         string `xml:"allowMultipleAds,attr"`
	FollowAdditionalWrappers string `xml:"followAdditionalWrappers,attr"`
	AdSystem                 string
	AdServingId              string
	Advertiser               Advertiser
	Description              string
	Expires                  string              `xml:",omitempty"`
	ViewableImpression       *ViewableImpression `xml:",omitempty"`
	Pricing                  Pricing4
	Impression               []Impression
	VASTAdTagURI             string
	Creatives                []Creative4 `xml:"Creatives>Creative"`
}

type InLine struct {
	AdSystem   string
	AdTitle    string
	Impression []Impression
	Creatives  []Creative `xml:"Creatives>Creative"`
}

type InLine3 struct {
	AdSystem   string
	AdTitle    string
	Pricing    Pricing
	Impression []Impression
	Creatives  []Creative `xml:"Creatives>Creative"`
}

type InLine4 struct {
	AdSystem           AdSystem
	Error              string
	AdTitle            string
	AdVerifications    *AdVerifications    `xml:"omitempty"`
	ViewableImpression *ViewableImpression `xml:",omitempty"`
	Category           []Category          `xml:",omitempty"`
	Pricing            Pricing4
	Impression         []Impression
	Creatives          []Creative4 `xml:"Creatives>Creative"`
}

type InLine41 struct {
	AdSystem           AdSystem
	AdServingId        string
	Advertiser         Advertiser
	Description        string
	Expires            string `xml:",omitempty"`
	Error              string
	AdTitle            string
	AdVerifications    *AdVerifications    `xml:"omitempty"`
	ViewableImpression *ViewableImpression `xml:",omitempty"`
	Category           []Category          `xml:",omitempty"`
	Pricing            Pricing4
	Impression         []Impression
	Creatives          []Creative4 `xml:"Creatives>Creative"`
}

type Pricing4 struct {
	Model    string `xml:"model,attr,omitempty"`
	Currency string `xml:"currency,attr,omitempty"`
	Value    string `xml:",chardata"`
}

type AdSystem struct {
	Key   string `xml:"version,attr,omitempty"`
	Value string `xml:",chardata"`
}

type Advertiser struct {
	Key   string `xml:"id,attr,omitempty"`
	Value string `xml:",chardata"`
}

type AdVerifications struct {
	Verification []*Verification `xml:",omitempty"`
}

type Category struct {
	Key   string `xml:"authority,attr,omitempty"`
	Value string `xml:",chardata"`
}

type ViewableImpression struct {
	Id               string `xml:"id,attr"`
	Viewable         string `xml:",omitempty"`
	NotViewable      string `xml:",omitempty"`
	ViewUndetermined string `xml:",omitempty"`
}

type Verification struct {
	XMLName            xml.Name `xml:"Verification"`
	JavaScriptResource string   `xml:",omitempty"`
	FlashResource      string   `xml:",omitempty"`
}

type Pricing struct {
	Model    string `xml:"model"`
	Currency string `xml:"currency"`
}

type Impression struct {
	Value string `xml:",chardata"`
}

type Creative struct {
	Linear       *Linear    `xml:"Linear,omitempty"`
	CompanionAds *Companion `xml:"CompanionAds>Companion,omitempty"`
}

type Creative4 struct {
	XMLName       xml.Name       `xml:"Creative"`
	UniversalAdId *UniversalAdId `xml:"UniversalAdId,omitempty"`
	Linear        *Linear4       `xml:"Linear,omitempty"`
	CompanionAds  *Companion     `xml:"CompanionAds>Companion,omitempty"`
}

type UniversalAdId struct {
	IdRegistry string `xml:"idRegistry,attr,omitempty"`
	IdValue    string `xml:"idValue,attr,omitempty"`
	Value      string `xml:",chardata"`
}

type Linear struct {
	Skipoffset     string      `xml:"skipoffset,attr,omitempty"`
	Duration       string      `xml:"Duration,omitempty"`
	TrackingEvents []Tracking  `xml:"TrackingEvents>Tracking,omitempty"`
	VideoClicks    VideoClicks `xml:",omitempty"`
	MediaFiles     MediaFile   `xml:"MediaFiles>MediaFile,omitempty"`
	Icons          *Icon       `xml:"Icons>Icon,omitempty"`
}

type Linear4 struct {
	Skipoffset     string       `xml:"skipoffset,attr,omitempty"`
	Duration       string       `xml:"Duration,omitempty"`
	TrackingEvents []Tracking   `xml:"TrackingEvents>Tracking,omitempty"`
	VideoClicks    *VideoClicks `xml:",omitempty"`
	MediaFiles     *MediaFiles  `xml:",omitempty"`
	Icons          *Icon        `xml:"Icons>Icon,omitempty"`
}

type Icon struct {
	Program          string            `xml:"program,attr,omitempty"`
	Height           string            `xml:"height,attr,omitempty"`
	Width            string            `xml:"width,attr,omitempty"`
	XPosition        string            `xml:"xPosition,attr,omitempty"`
	YPosition        string            `xml:"yPosition,attr,omitempty"`
	ApiFramework     string            `xml:"apiFramework,attr,omitempty"`
	Offset           string            `xml:"offset,attr,omitempty"`
	Duration         string            `xml:"duration,attr,omitempty"`
	StaticResource   StaticResource    `xml:",omitempty"`
	HTMLResource     HTMLResource      `xml:",omitempty"`
	IconClicks       *IconClickThrough `xml:"IconClicks>IconClickThrough,omitempty"`
	IconViewTracking string            `xml:",omitempty"`
}

type IconClickThrough struct {
	Value string `xml:",chardata"`
}

type HTMLResource struct {
	Value string `xml:",chardata"`
}

type MediaFiles struct {
	ClosedCaptionFiles      *ClosedCaptionFiles `xml:",omitempty"`
	MediaFile               []MediaFile         `xml:",omitempty"`
	InteractiveCreativeFile string              `xml:",omitempty"`
	Mezzanine               []Mezzanine         `xml:",omitempty"`
}

type ClosedCaptionFiles struct {
	ClosedCaptionFile []ClosedCaptionFile `xml:",omitempty"`
}

type ClosedCaptionFile struct {
	Type     string `xml:"type,attr,omitempty"`
	Language string `xml:"language,attr,omitempty"`
	Value    string `xml:",chardata"`
}

type Mezzanine struct {
	Value string `xml:",chardata"`
}

type MediaFile struct {
	Value               string `xml:",chardata"`
	Delivery            string `xml:"delivery,attr,omitempty"`
	Bitrate             string `xml:"bitrate,attr,omitempty"`
	Width               string `xml:"width,attr,omitempty"`
	Height              string `xml:"height,attr,omitempty"`
	MaxBitrate          string `xml:"maxBitrate,attr,omitempty"`
	MinBitrate          string `xml:"minBitrate,attr,omitempty"`
	Type                string `xml:"type,attr,omitempty"`
	Scalable            string `xml:"scalable,attr,omitempty"`
	MaintainAspectRatio string `xml:"maintainAspectRatio,attr,omitempty"`
}

type VideoClicks struct {
	ClickThrough string `xml:",omitempty"`
}

type Tracking struct {
	Key   string `xml:"event,attr,omitempty"`
	Value string `xml:",chardata"`
}

type Companion struct {
	Width                 string                `xml:"width,attr,omitempty"`
	Height                string                `xml:"height,attr,omitempty"`
	StaticResource        StaticResource        `xml:",omitempty"`
	CompanionClickThrough CompanionClickThrough `xml:",omitempty"`
}

type StaticResource struct {
	Key   string `xml:"creativeType,attr,omitempty"`
	Value string `xml:",chardata"`
}

type CompanionClickThrough struct {
	Value string `xml:",chardata"`
}
